
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Ringo")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(3.18*x1 + 2.93*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + 10*x2 >= 53, "computer_competence_rating")
m.addConstr(2*x1 + 5*x2 >= 27, "paperwork_competence_rating")
m.addConstr(-6*x1 + 10*x2 >= 0, "additional_constraint")
m.addConstr(9*x1 + 10*x2 <= 110, "max_computer_competence")
m.addConstr(2*x1 + 5*x2 <= 73, "max_paperwork_competence")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
else:
    print("No optimal solution found")
