
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Ringo', lb=0)  # Assuming non-negativity
    x2 = model.addVar(name='hours_worked_by_Bobby', lb=0)  # Assuming non-negativity

    # Define the objective function
    model.setObjective(3.18 * x1 + 2.93 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * x1 + 10 * x2 >= 53)
    model.addConstr(2 * x1 + 5 * x2 >= 27)
    model.addConstr(-6 * x1 + 10 * x2 >= 0)
    model.addConstr(9 * x1 + 10 * x2 <= 110)
    model.addConstr(2 * x1 + 5 * x2 <= 73)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Ringo: {x1.varValue}')
        print(f'Hours worked by Bobby: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
