
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(name="hot_dogs")
bagged_salads = m.addVar(name="bagged_salads")
peanutbutter_sandwiches = m.addVar(name="peanutbutter_sandwiches")


# Set objective function
m.setObjective(4*hot_dogs*bagged_salads + 8*hot_dogs*peanutbutter_sandwiches + 4*bagged_salads**2 + 7*bagged_salads*peanutbutter_sandwiches + 5*hot_dogs + 2*bagged_salads + 3*peanutbutter_sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1*hot_dogs + 5*bagged_salads + 8*peanutbutter_sandwiches <= 59, "iron_upper_bound")
m.addConstr(3*hot_dogs + 5*bagged_salads + 3*peanutbutter_sandwiches <= 86, "fiber_upper_bound")
m.addConstr(hot_dogs**2 + peanutbutter_sandwiches**2 >= 16, "iron_constraint1")
m.addConstr(bagged_salads + peanutbutter_sandwiches >= 9, "iron_constraint2")
m.addConstr(hot_dogs**2 + bagged_salads**2 + peanutbutter_sandwiches**2 >= 14, "iron_constraint3")
m.addConstr(hot_dogs + bagged_salads + peanutbutter_sandwiches >= 14, "iron_constraint4")
m.addConstr(bagged_salads + peanutbutter_sandwiches >= 27, "fiber_constraint1")
m.addConstr(3*hot_dogs + 5*bagged_salads + 3*peanutbutter_sandwiches >= 27, "fiber_constraint2")
m.addConstr(hot_dogs - 7*bagged_salads >= 0, "constraint1")
m.addConstr(5*hot_dogs - 8*peanutbutter_sandwiches >= 0, "constraint2")
m.addConstr(bagged_salads + peanutbutter_sandwiches <= 21, "iron_constraint5")
m.addConstr(hot_dogs**2 + peanutbutter_sandwiches**2 <= 39, "iron_constraint6")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

