
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hot_dogs", lb=0)
x1 = m.addVar(name="bagged_salads", lb=0)
x2 = m.addVar(name="peanutbutter_sandwiches", lb=0)

# Objective function
m.setObjective(4*x0*x1 + 8*x0*x2 + 4*x1**2 + 7*x1*x2 + 5*x0 + 2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 <= 59)
m.addConstr(3*x0 <= 86)
m.addConstr(5*x1 <= 59)
m.addConstr(5*x1 <= 86)
m.addConstr(8*x2 <= 59)
m.addConstr(3*x2 <= 86)
m.addConstr(x0**2 + x2**2 >= 16)
m.addConstr(x1 + x2 >= 9)
m.addConstr(x0**2 + x1**2 + x2**2 >= 14)
m.addConstr(x0 + x1 + x2 >= 14)
m.addConstr(x1 + x2 >= 27)
m.addConstr(x0 + x1 + x2 >= 27)
m.addConstr(x0 - 7*x1 >= 0)
m.addConstr(5*x0 - 8*x2 >= 0)
m.addConstr(x1 + x2 <= 21)
m.addConstr(x0**2 + x2**2 <= 39)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hot dogs: ", x0.varValue)
    print("Bagged salads: ", x1.varValue)
    print("Peanutbutter sandwiches: ", x2.varValue)
else:
    print("The model is infeasible")
