
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0")  # Peggy
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1")  # Hank
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # Bill
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # John
    x4 = model.addVar(vtype=gp.GRB.INTEGER, name="x4")  # Jean


    # Set objective function
    model.setObjective(3*x0**2 + 5*x0*x2 + 8*x1*x2 + 7*x1*x3 + 6*x1*x4 + 5*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 5*x4 >= 23)
    model.addConstr(4*x1 + 16*x2 >= 14)
    model.addConstr(4*x1 + 16*x2 + 5*x4 >= 26)
    model.addConstr(4*x1 + 14*x3 + 5*x4 >= 26)
    model.addConstr(15*x0**2 + 4*x1**2 + 5*x4**2 >= 26)
    model.addConstr(15*x0**2 + 16*x2**2 + 5*x4**2 >= 26)
    model.addConstr(16*x2**2 + 14*x3**2 + 5*x4**2 >= 26)
    model.addConstr(4*x1 + 16*x2 + 5*x4 >= 17)
    model.addConstr(4*x1 + 14*x3 + 5*x4 >= 17)
    model.addConstr(15*x0 + 4*x1 + 5*x4 >= 17)
    model.addConstr(15*x0 + 16*x2 + 5*x4 >= 17)
    model.addConstr(16*x2 + 14*x3 + 5*x4 >= 17)
    model.addConstr(4*x1 + 16*x2 + 5*x4 >= 18)
    model.addConstr(4*x1**2 + 14*x3**2 + 5*x4**2 >= 18)
    model.addConstr(15*x0 + 4*x1 + 5*x4 >= 18)
    model.addConstr(15*x0**2 + 16*x2**2 + 5*x4**2 >= 18)
    model.addConstr(16*x2 + 14*x3 + 5*x4 >= 18)
    model.addConstr(4*x1 + 16*x2 + 5*x4 >= 15)
    model.addConstr(4*x1 + 14*x3 + 5*x4 >= 15)
    model.addConstr(15*x0**2 + 4*x1**2 + 5*x4**2 >= 15)
    model.addConstr(15*x0**2 + 16*x2**2 + 5*x4**2 >= 15)
    model.addConstr(16*x2 + 14*x3 + 5*x4 >= 15)
    model.addConstr(4*x1 + 16*x2 + 5*x4 >= 18)
    model.addConstr(4*x1 + 14*x3 + 5*x4 >= 18)
    model.addConstr(15*x0 + 4*x1 + 5*x4 >= 18)
    model.addConstr(15*x0 + 16*x2 + 5*x4 >= 18)
    model.addConstr(16*x2 + 14*x3 + 5*x4 >= 18)
    model.addConstr(15*x0 + 4*x1 + 16*x2 + 14*x3 + 5*x4 >= 18)
    model.addConstr(x1 - 9*x4 >= 0)
    model.addConstr(5*x0 - 4*x3 >= 0)
    model.addConstr(-6*x2**2 + 6*x4**2 >= 0)
    model.addConstr(4*x1**2 + 14*x3**2 <= 74)
    model.addConstr(16*x2 + 5*x4 <= 59)
    model.addConstr(15*x0 + 5*x4 <= 42)
    model.addConstr(15*x0 + 4*x1 <= 52)
    model.addConstr(14*x3 + 5*x4 <= 58)
    model.addConstr(15*x0 + 16*x2 <= 129)
    model.addConstr(15*x0 + 14*x3 <= 145)
    model.addConstr(16*x2**2 + 14*x3**2 <= 82)
    model.addConstr(4*x1 + 5*x4 <= 35)
    model.addConstr(4*x1 + 14*x3 + 5*x4 <= 84)
    model.addConstr(15*x0 + 4*x1 + 14*x3 <= 75)



    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
