
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
x3 = m.addVar(name="x3")  # hours worked by Bill
x4 = m.addVar(name="x4")  # hours worked by John
x5 = m.addVar(name="x5", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean

# Objective function
m.setObjective(3*x1**2 + 5*x1*x3 + 8*x2*x3 + 7*x2*x4 + 6*x2*x5 + 5*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(15*x1 == 15)
m.addConstr(4*x2 == 4)
m.addConstr(16*x3 == 16)
m.addConstr(14*x4 == 14)
m.addConstr(5*x5 == 5)
m.addConstr(4*x2 + 5*x5 >= 23)
m.addConstr(4*x2 + 16*x3 >= 14)
m.addConstr(4*x2 + 16*x3 + 5*x5 >= 26)
m.addConstr(4*x2 + 14*x4 + 5*x5 >= 26)
m.addConstr(15**2*x1**2 + 4**2*x2**2 + 5**2*x5**2 >= 26)
m.addConstr(15**2*x1**2 + 16**2*x3**2 + 5**2*x5**2 >= 26)
m.addConstr(16**2*x3**2 + 14**2*x4**2 + 5**2*x5**2 >= 26)
m.addConstr(4*x2 + 16*x3 + 5*x5 >= 17)
m.addConstr(4*x2 + 14*x4 + 5*x5 >= 17)
m.addConstr(15*x1 + 4*x2 + 5*x5 >= 17)
m.addConstr(15*x1 + 16*x3 + 5*x5 >= 17)
m.addConstr(16*x3 + 14*x4 + 5*x5 >= 17)
m.addConstr(4*x2 + 16*x3 + 5*x5 >= 18)
m.addConstr(4**2*x2**2 + 14**2*x4**2 + 5**2*x5**2 >= 18)
m.addConstr(15*x1 + 4*x2 + 5*x5 >= 18)
m.addConstr(15**2*x1**2 + 16**2*x3**2 + 5**2*x5**2 >= 18)
m.addConstr(16*x3 + 14*x4 + 5*x5 >= 18)
m.addConstr(4*x2 + 16*x3 + 5*x5 >= 15)
m.addConstr(4*x2 + 14*x4 + 5*x5 >= 15)
m.addConstr(15**2*x1**2 + 4**2*x2**2 + 5**2*x5**2 >= 15)
m.addConstr(15**2*x1**2 + 16**2*x3**2 + 5**2*x5**2 >= 15)
m.addConstr(16*x3 + 14*x4 + 5*x5 >= 15)
m.addConstr(4*x2 + 16*x3 + 5*x5 >= 18)
m.addConstr(4*x2 + 14*x4 + 5*x5 >= 18)
m.addConstr(15*x1 + 4*x2 + 5*x5 >= 18)
m.addConstr(15*x1 + 16*x3 + 5*x5 >= 18)
m.addConstr(16*x3 + 14*x4 + 5*x5 >= 18)
m.addConstr(15*x1 + 4*x2 + 16*x3 + 14*x4 + 5*x5 >= 18)
m.addConstr(x2 - 9*x5 >= 0)
m.addConstr(5*x1 - 4*x4 >= 0)
m.addConstr(-6*x3**2 + 6*x5**2 >= 0)
m.addConstr(4**2*x2**2 + 14**2*x4**2 <= 74)
m.addConstr(16*x3 + 5*x5 <= 59)
m.addConstr(15*x1 + 5*x5 <= 42)
m.addConstr(15*x1 + 4*x2 <= 52)
m.addConstr(14*x4 + 5*x5 <= 58)
m.addConstr(15*x1 + 16*x3 <= 129)
m.addConstr(15*x1 + 14*x4 <= 145)
m.addConstr(16**2*x3**2 + 14**2*x4**2 <= 82)
m.addConstr(4*x2 + 5*x5 <= 35)
m.addConstr(4*x2 + 14*x4 + 5*x5 <= 84)
m.addConstr(15*x1 + 4*x2 + 14*x4 <= 75)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("The model is infeasible")
