
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
cantaloupes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")


# Set objective function
m.setObjective(8*hot_dogs + 4*lemons + 8*corn_cobs + 5*cantaloupes + 8*kiwis, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*hot_dogs + 6*lemons >= 19)
m.addConstr(10*hot_dogs + 24*corn_cobs >= 27)
m.addConstr(6*lemons + 1*cantaloupes >= 26)
m.addConstr(10*hot_dogs + 23*kiwis >= 16)
m.addConstr(24*corn_cobs + 1*cantaloupes >= 39)
m.addConstr(6*lemons + 24*corn_cobs >= 17)
m.addConstr(24*corn_cobs + 23*kiwis >= 33)
m.addConstr(1*cantaloupes + 23*kiwis >= 18)
m.addConstr(10*hot_dogs + 1*cantaloupes >= 48)
m.addConstr(10*hot_dogs + 6*lemons + 1*cantaloupes >= 37)
m.addConstr(10*hot_dogs + 6*lemons + 24*corn_cobs >= 37)
m.addConstr(10*hot_dogs + 6*lemons + 1*cantaloupes >= 46)
m.addConstr(10*hot_dogs + 6*lemons + 24*corn_cobs >= 46)
m.addConstr(2*corn_cobs + 23*cantaloupes + 26*kiwis >= 27)
m.addConstr(19*hot_dogs + 2*corn_cobs + 26*kiwis >= 27)
m.addConstr(19*hot_dogs + 23*cantaloupes + 26*kiwis >= 27)
m.addConstr(19*hot_dogs + 2*corn_cobs + 23*cantaloupes >= 27)
m.addConstr(14*lemons + 23*cantaloupes + 26*kiwis >= 27)
m.addConstr(2*corn_cobs + 23*cantaloupes + 26*kiwis >= 34)
m.addConstr(19*hot_dogs + 2*corn_cobs + 26*kiwis >= 34)
m.addConstr(19*hot_dogs + 23*cantaloupes + 26*kiwis >= 34)
m.addConstr(19*hot_dogs + 2*corn_cobs + 23*cantaloupes >= 34)
m.addConstr(14*lemons + 23*cantaloupes + 26*kiwis >= 34)
m.addConstr(2*corn_cobs + 23*cantaloupes + 26*kiwis >= 32)
m.addConstr(19*hot_dogs + 2*corn_cobs + 26*kiwis >= 32)
m.addConstr(19*hot_dogs + 23*cantaloupes + 26*kiwis >= 32)
m.addConstr(19*hot_dogs + 2*corn_cobs + 23*cantaloupes >= 32)
m.addConstr(14*lemons + 23*cantaloupes + 26*kiwis >= 32)
m.addConstr(2*corn_cobs + 23*cantaloupes + 26*kiwis >= 46)
m.addConstr(19*hot_dogs + 2*corn_cobs + 26*kiwis >= 46)
m.addConstr(19*hot_dogs + 23*cantaloupes + 26*kiwis >= 46)
m.addConstr(19*hot_dogs + 2*corn_cobs + 23*cantaloupes >= 46)
m.addConstr(14*lemons + 23*cantaloupes + 26*kiwis >= 46)
m.addConstr(2*corn_cobs + 23*cantaloupes + 26*kiwis >= 37)
m.addConstr(19*hot_dogs + 2*corn_cobs + 26*kiwis >= 37)
m.addConstr(19*hot_dogs + 23*cantaloupes + 26*kiwis >= 37)
m.addConstr(19*hot_dogs + 2*corn_cobs + 23*cantaloupes >= 37)
m.addConstr(14*lemons + 23*cantaloupes + 26*kiwis >= 37)
m.addConstr(6*lemons + 23*kiwis <= 169)
m.addConstr(10*hot_dogs + 24*corn_cobs <= 85)
m.addConstr(24*corn_cobs + 23*kiwis <= 185)
m.addConstr(24*corn_cobs + 1*cantaloupes <= 171)
m.addConstr(10*hot_dogs + 23*kiwis <= 83)
m.addConstr(1*cantaloupes + 23*kiwis <= 53)
m.addConstr(10*hot_dogs + 6*lemons <= 229)
m.addConstr(10*hot_dogs + 6*lemons + 23*kiwis <= 154)
m.addConstr(24*corn_cobs + 1*cantaloupes + 23*kiwis <= 141)
m.addConstr(10*hot_dogs + 6*lemons + 24*corn_cobs + 1*cantaloupes + 23*kiwis <= 141)
m.addConstr(19*hot_dogs + 26*kiwis <= 273)
m.addConstr(2*corn_cobs + 26*kiwis <= 123)
m.addConstr(14*lemons + 2*corn_cobs <= 216)
m.addConstr(19*hot_dogs + 23*cantaloupes <= 56)
m.addConstr(19*hot_dogs + 2*corn_cobs <= 87)
m.addConstr(2*corn_cobs + 23*cantaloupes <= 243)
m.addConstr(19*hot_dogs + 14*lemons + 2*corn_cobs + 23*cantaloupes + 26*kiwis <= 243)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

