
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")

    # Set objective function
    m.setObjective(5*carbohydrates + 2*vitamin_d + 6*zinc + 8*protein, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*carbohydrates + 10*vitamin_d >= 26, "c1")
    m.addConstr(8*carbohydrates + 7*zinc + 10*protein >= 35, "c2")
    m.addConstr(10*vitamin_d + 7*zinc + 10*protein >= 35, "c3")
    m.addConstr(8*carbohydrates + 10*vitamin_d + 7*zinc + 10*protein >= 35, "c4")
    m.addConstr(11*carbohydrates + 5*zinc >= 25, "c5")
    m.addConstr(11*carbohydrates + 4*protein >= 14, "c6")
    m.addConstr(11*carbohydrates + 9*vitamin_d + 5*zinc + 4*protein >= 14, "c7")
    m.addConstr(-8*vitamin_d + 6*protein >= 0, "c8")
    m.addConstr(-4*carbohydrates + 6*vitamin_d >= 0, "c9")
    m.addConstr(8*carbohydrates + 10*vitamin_d + 7*zinc <= 94, "c10")
    m.addConstr(10*vitamin_d + 7*zinc + 10*protein <= 144, "c11")
    m.addConstr(9*vitamin_d + 4*protein <= 89, "c12")
    m.addConstr(9*vitamin_d + 5*zinc <= 81, "c13")
    m.addConstr(11*carbohydrates + 9*vitamin_d + 5*zinc <= 60, "c14")


    # Resource Constraints
    m.addConstr(8*carbohydrates <= 181, "r0_digestive_support")
    m.addConstr(11*carbohydrates <= 152, "r1_muscle_growth")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
