
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0) # grams of carbohydrates
    x1 = model.addVar(name="x1", lb=0) # milligrams of vitamin D
    x2 = model.addVar(name="x2", lb=0) # milligrams of zinc
    x3 = model.addVar(name="x3", lb=0) # grams of protein

    # Objective function
    model.setObjective(5*x0 + 2*x1 + 6*x2 + 8*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x0 <= 181)
    model.addConstr(11*x0 <= 152)
    model.addConstr(10*x1 <= 181)
    model.addConstr(9*x1 <= 152)
    model.addConstr(7*x2 <= 181)
    model.addConstr(5*x2 <= 152)
    model.addConstr(10*x3 <= 181)
    model.addConstr(4*x3 <= 152)
    model.addConstr(8*x0 + 10*x1 >= 26)
    model.addConstr(8*x0 + 7*x2 + 10*x3 >= 35)
    model.addConstr(10*x1 + 7*x2 + 10*x3 >= 35)
    model.addConstr(8*x0 + 7*x2 + 10*x3 >= 35)
    model.addConstr(10*x1 + 7*x2 + 10*x3 >= 35)
    model.addConstr(8*x0 + 10*x1 + 7*x2 + 10*x3 >= 35)
    model.addConstr(11*x0 + 5*x2 >= 25)
    model.addConstr(11*x0 + 4*x3 >= 14)
    model.addConstr(11*x0 + 9*x1 + 5*x2 + 4*x3 >= 14)
    model.addConstr(-8*x1 + 6*x3 >= 0)
    model.addConstr(-4*x0 + 6*x1 >= 0)
    model.addConstr(8*x0 + 10*x1 + 7*x2 <= 94)
    model.addConstr(10*x1 + 7*x2 + 10*x3 <= 144)
    model.addConstr(9*x1 + 4*x3 <= 89)
    model.addConstr(9*x1 + 5*x2 <= 81)
    model.addConstr(11*x0 + 9*x1 + 5*x2 <= 60)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
