
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("carbohydrate_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="corn_cobs")


    # Set objective function
    m.setObjective(6.74 * x0 + 9.12 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11 * x0 + 10 * x1 >= 16, "carbohydrate_minimum")
    m.addConstr(8 * x0 - 6 * x1 >= 0, "pasta_corn_ratio")
    m.addConstr(11 * x0 + 10 * x1 <= 50, "carbohydrate_maximum")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Bowls of pasta: {x0.x}")
        print(f"Corn cobs: {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

