
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_pasta")
x2 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")

# Objective function
m.setObjective(6.74*x1 + 9.12*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(11*x1 + 10*x2 >= 16, "carbohydrates_min")
m.addConstr(8*x1 - 6*x2 >= 0, "pasta_corn_relation")
m.addConstr(11*x1 + 10*x2 <= 50, "total_carbohydrates_max")

# Non-negativity constraints (implied by GRB.INTEGER and default lower bound of 0)

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bowls of pasta: {x1.x}")
    print(f"Number of corn cobs: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
