
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bowls_of_pasta", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="corn_cobs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6.74 * x1 + 9.12 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11 * x1 + 10 * x2 >= 16, name="carbohydrates_min")
    model.addConstr(11 * x1 + 10 * x2 <= 54, name="carbohydrates_max")
    model.addConstr(8 * x1 - 6 * x2 >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bowls of pasta: {x1.varValue}")
        print(f"Corn cobs: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
