
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="scissors")
x1 = m.addVar(vtype=GRB.INTEGER, name="color_printers")

# Set objective function
m.setObjective(9.7*x0 + 3.74*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(9.7*x0 + 19*x1 >= 45, "min_cost")
m.addConstr(9.7*x0 + 19*x1 <= 105, "max_cost")
m.addConstr(30*x0 + 7*x1 >= 119, "min_usefulness")
m.addConstr(30*x0 + 7*x1 <= 319, "max_usefulness")
m.addConstr(21*x0 + 23*x1 >= 36, "min_sustainability")
m.addConstr(21*x0 + 23*x1 <= 83, "max_sustainability")
m.addConstr(-7*x0 + 7*x1 >= 0, "balance")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Scissors: {x0.x}")
    print(f"Color Printers: {x1.x}")
else:
    print("No optimal solution found")
