
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    scissors = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    color_printers = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9.7 * scissors + 3.74 * color_printers, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(scissors + 19 * color_printers >= 45)
    model.addConstr(scissors + 19 * color_printers <= 116)
    model.addConstr(30 * scissors + 7 * color_printers >= 119)
    model.addConstr(30 * scissors + 7 * color_printers <= 319)
    model.addConstr(21 * scissors + 23 * color_printers >= 36)
    model.addConstr(21 * scissors + 23 * color_printers <= 83)
    model.addConstr(-7 * scissors + 7 * color_printers >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Scissors: {scissors.varValue}")
        print(f"Color Printers: {color_printers.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
