
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
    bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
    peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
    protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")

    # Set objective function
    m.setObjective(4.81 * ravioli + 3.72 * bananas + 9.94 * peanutbutter_sandwiches + 3.33 * protein_bars, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(peanutbutter_sandwiches + 3 * protein_bars >= 18)
    m.addConstr(4 * ravioli + peanutbutter_sandwiches >= 17)
    m.addConstr(4 * ravioli + 5 * bananas >= 10)
    m.addConstr(4 * ravioli + 3 * protein_bars >= 14)
    m.addConstr(4 * ravioli + 3 * protein_bars <= 66)
    m.addConstr(4 * ravioli + peanutbutter_sandwiches <= 51)
    m.addConstr(5 * bananas + peanutbutter_sandwiches + 3 * protein_bars <= 21)
    m.addConstr(4 * ravioli + 5 * bananas + 3 * protein_bars <= 21)
    m.addConstr(4 * ravioli + 5 * bananas + peanutbutter_sandwiches <= 80)
    m.addConstr(4 * ravioli + 5 * bananas + peanutbutter_sandwiches + 3 * protein_bars <= 80)
    m.addConstr(2 * ravioli + 2 * bananas <= 38)
    m.addConstr(2 * bananas + 4 * protein_bars <= 35)
    m.addConstr(2 * bananas + peanutbutter_sandwiches <= 23)
    m.addConstr(2 * ravioli + peanutbutter_sandwiches + 4 * protein_bars <= 43)
    m.addConstr(2 * ravioli + 2 * bananas + peanutbutter_sandwiches + 4 * protein_bars <= 43)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
