
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="ravioli", lb=0)
    x1 = model.addVar(name="bananas", lb=0)
    x2 = model.addVar(name="peanutbutter sandwiches", lb=0)
    x3 = model.addVar(name="protein bars", lb=0)

    # Objective function
    model.setObjective(4.81*x0 + 3.72*x1 + 9.94*x2 + 3.33*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x0 + 5*x1 + 1*x2 + 3*x3 <= 80, name="umami_total")
    model.addConstr(2*x0 + 2*x1 + 1*x2 + 4*x3 <= 52, name="healthiness_total")
    model.addConstr(1*x2 + 3*x3 >= 18, name="umami_pb_protein")
    model.addConstr(4*x0 + 1*x2 >= 17, name="umami_ravioli_pb")
    model.addConstr(4*x0 + 5*x1 >= 10, name="umami_ravioli_bananas")
    model.addConstr(4*x0 + 3*x3 >= 14, name="umami_ravioli_protein")
    model.addConstr(4*x0 + 3*x3 <= 66, name="umami_ravioli_protein_upper")
    model.addConstr(4*x0 + 1*x2 <= 51, name="umami_ravioli_pb_upper")
    model.addConstr(5*x1 + 1*x2 + 3*x3 <= 21, name="umami_bananas_pb_protein")
    model.addConstr(4*x0 + 5*x1 + 3*x3 <= 21, name="umami_ravioli_bananas_protein")
    model.addConstr(4*x0 + 5*x1 + 1*x2 <= 80, name="umami_ravioli_bananas_pb")
    model.addConstr(4*x0 + 5*x1 + 1*x2 + 3*x3 <= 80, name="umami_total_all")
    model.addConstr(2*x0 + 2*x1 <= 38, name="healthiness_ravioli_bananas")
    model.addConstr(2*x1 + 4*x3 <= 35, name="healthiness_bananas_protein")
    model.addConstr(2*x1 + 1*x2 <= 23, name="healthiness_bananas_pb")
    model.addConstr(2*x0 + 1*x2 + 4*x3 <= 43, name="healthiness_ravioli_pb_protein")
    model.addConstr(2*x0 + 2*x1 + 1*x2 + 4*x3 <= 43, name="healthiness_total_all")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Ravioli: ", x0.varValue)
        print("Bananas: ", x1.varValue)
        print("Peanutbutter sandwiches: ", x2.varValue)
        print("Protein bars: ", x3.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
