
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=gp.GRB.INTEGER, name="wooden_pencils")
x1 = model.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")
x2 = model.addVar(vtype=gp.GRB.INTEGER, name="mechanical_pencils")
x3 = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")

# Set objective function
model.setObjective(6*x0 + 2*x1 + 8*x2 + 2*x3, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3.92*x0 + 0.95*x1 >= 26)
model.addConstr(0.95*x1 + 3.15*x2 >= 36)
model.addConstr(0.95*x1 + 2.29*x3 >= 56)
model.addConstr(3.92*x0 + 2.29*x3 >= 55)
model.addConstr(3.92*x0 + 0.95*x1 + 3.15*x2 + 2.29*x3 >= 55)
model.addConstr(3.18*x0 + 2.76*x1 >= 29)
model.addConstr(3.18*x0 + 3.35*x2 >= 18)
model.addConstr(3.35*x2 + 1.33*x3 >= 26)
model.addConstr(2.76*x1 + 3.35*x2 >= 35)
model.addConstr(2.76*x1 + 1.33*x3 >= 34)
model.addConstr(3.18*x0 + 2.76*x1 + 3.35*x2 >= 38)
model.addConstr(2.76*x1 + 3.35*x2 + 1.33*x3 >= 38)
model.addConstr(3.18*x0 + 2.76*x1 + 3.35*x2 >= 46)
model.addConstr(2.76*x1 + 3.35*x2 + 1.33*x3 >= 46)
model.addConstr(3.18*x0 + 2.76*x1 + 3.35*x2 + 1.33*x3 >= 46)
model.addConstr(-5*x2 + 5*x3 >= 0)
model.addConstr(3.92*x0 + 0.95*x1 + 3.15*x2 <= 253)
model.addConstr(3.92*x0 + 0.95*x1 + 2.29*x3 <= 82)
model.addConstr(3.92*x0 + 3.15*x2 + 2.29*x3 <= 72)
model.addConstr(2.76*x1 + 1.33*x3 <= 85)
model.addConstr(2.76*x1 + 3.35*x2 <= 150)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

