
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B4
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin C


    # Set objective function
    m.setObjective(8*x0 + 3*x1 + 3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(32*x0 + 12*x1 >= 35, "c1")
    m.addConstr(12*x1 + 19*x2 >= 74, "c2")
    m.addConstr(32*x0 + 19*x2 <= 228, "c3")
    m.addConstr(32*x0 + 12*x1 <= 145, "c4")
    m.addConstr(32*x0 + 12*x1 + 19*x2 <= 145, "c5")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

