
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B6")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B4")
x3 = m.addVar(lb=0, name="milligrams_of_vitamin_C")

# Set the objective function
m.setObjective(8*x1 + 3*x2 + 3*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(32*x1 + 12*x2 >= 35, "immune_support_B6_B4")
m.addConstr(12*x2 + 19*x3 >= 74, "immune_support_B4_C")
m.addConstr(32*x1 + 19*x3 <= 228, "max_immune_support_B6_C")
m.addConstr(32*x1 + 12*x2 <= 145, "max_immune_support_B6_B4")
m.addConstr(32*x1 + 12*x2 + 19*x3 <= 145, "total_max_immune_support")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B6: {x1.x}")
    print(f"Milligrams of Vitamin B4: {x2.x}")
    print(f"Milligrams of Vitamin C: {x3.x}")
else:
    print("No optimal solution found")
