
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='milligrams_of_vitamin_B6', lb=0)
x2 = model.addVar(name='milligrams_of_vitamin_B4', lb=0)
x3 = model.addVar(name='milligrams_of_vitamin_C', lb=0)

# Objective function
model.setObjective(8*x1 + 3*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(32*x1 + 12*x2 >= 35)
model.addConstr(12*x2 + 19*x3 >= 74)
model.addConstr(32*x1 + 19*x3 <= 228)
model.addConstr(32*x1 + 12*x2 <= 145)
model.addConstr(32*x1 + 12*x2 + 19*x3 <= 145)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('The model is infeasible')
