
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Combined_Hours")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill_hours")


    # Set objective function
    model.setObjective(9 * laura_hours + 8 * bill_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * laura_hours + 3 * bill_hours >= 34, "c1")
    model.addConstr(13 * laura_hours + 4 * bill_hours >= 13, "c2")
    model.addConstr(10 * laura_hours + 14 * bill_hours >= 36, "c3")
    model.addConstr(7 * laura_hours + 17 * bill_hours >= 39, "c4")
    model.addConstr(-3 * laura_hours + bill_hours >= 0, "c5")
    model.addConstr(11 * laura_hours + 3 * bill_hours <= 52, "c6")
    model.addConstr(13 * laura_hours + 4 * bill_hours <= 38, "c7")
    model.addConstr(10 * laura_hours + 14 * bill_hours <= 59, "c8")
    model.addConstr(7 * laura_hours + 17 * bill_hours <= 77, "c9")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Laura's Hours: {laura_hours.x}")
        print(f"Bill's Hours: {bill_hours.x}")
        print(f"Objective Value: {model.objVal}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
