
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(9*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(11*x1 + 3*x2 >= 34, "likelihood_to_quit_index_min")
m.addConstr(13*x1 + 4*x2 >= 13, "dollar_cost_per_hour_min")
m.addConstr(10*x1 + 14*x2 >= 36, "productivity_rating_min")
m.addConstr(7*x1 + 17*x2 >= 39, "computer_competence_rating_min")
m.addConstr(-3*x1 + x2 >= 0, "other_constraint")
m.addConstr(11*x1 + 3*x2 <= 52, "likelihood_to_quit_index_max")
m.addConstr(13*x1 + 4*x2 <= 38, "dollar_cost_per_hour_max")
m.addConstr(10*x1 + 14*x2 <= 59, "productivity_rating_max")
m.addConstr(7*x1 + 17*x2 <= 77, "computer_competence_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
