
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Laura", lb=0)  # Laura
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0, integrality=gurobi.GRB.INTEGER)  # Bill

    # Objective function
    model.setObjective(9 * x0 + 8 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11 * x0 + 3 * x1 >= 34)
    model.addConstr(13 * x0 + 4 * x1 >= 13)
    model.addConstr(10 * x0 + 14 * x1 >= 36)
    model.addConstr(7 * x0 + 17 * x1 >= 39)
    model.addConstr(-3 * x0 + x1 >= 0)
    model.addConstr(11 * x0 + 3 * x1 <= 52)
    model.addConstr(13 * x0 + 4 * x1 <= 38)
    model.addConstr(10 * x0 + 14 * x1 <= 59)
    model.addConstr(7 * x0 + 17 * x1 <= 77)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x0.varValue}")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
