
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B2")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")


    # Set objective function
    m.setObjective(6*x0 + 2*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 11*x1 >= 17, "c1")
    m.addConstr(2*x0 + 2*x2 >= 25, "c2")
    m.addConstr(2*x0 + 11*x1 + 2*x2 >= 25, "c3")
    m.addConstr(9*x1 + 5*x2 >= 5, "c4")
    m.addConstr(10*x0 + 9*x1 >= 13, "c5")
    m.addConstr(10*x0 + 9*x1 + 5*x2 >= 13, "c6")
    m.addConstr(1*x1 + 6*x2 >= 20, "c7")
    m.addConstr(7*x0 + 6*x2 >= 13, "c8")
    m.addConstr(7*x0 + 1*x1 + 6*x2 >= 13, "c9")
    m.addConstr(-9*x0 + 5*x2 >= 0, "c10")
    m.addConstr(2*x0 + 2*x2 <= 58, "c11")
    m.addConstr(10*x0 + 9*x1 + 5*x2 <= 32, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B2: %g' % x0.x)
        print('Iron: %g' % x1.x)
        print('Vitamin B12: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
