
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B2
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of iron
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B12

    # Objective function
    model.setObjective(6 * x1 + 2 * x2 + 6 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 11 * x2 + 2 * x3 >= 17)
    model.addConstr(2 * x1 + 2 * x3 >= 25)
    model.addConstr(10 * x1 + 9 * x2 >= 13)
    model.addConstr(9 * x2 + 5 * x3 >= 5)
    model.addConstr(7 * x1 + x2 + 6 * x3 >= 13)
    model.addConstr(x2 + 6 * x3 >= 20)
    model.addConstr(-9 * x1 + 5 * x3 >= 0)
    model.addConstr(2 * x1 + 2 * x3 <= 58)
    model.addConstr(10 * x1 + 9 * x2 + 5 * x3 <= 32)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of iron: {x2.varValue}")
        print(f"Milligrams of vitamin B12: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
