
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")

    # Set objective function
    m.setObjective(4 * vitamin_d + 8 * fat + 3 * vitamin_c, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5.48 * vitamin_d + 4.28 * fat >= 40, "c1")
    m.addConstr(5.48 * vitamin_d + 4.11 * vitamin_c >= 19, "c2")
    m.addConstr(5.48 * vitamin_d + 4.28 * fat + 4.11 * vitamin_c >= 19, "c3")
    m.addConstr(1.65 * vitamin_d + 2.11 * fat >= 18, "c4")
    m.addConstr(2.11 * fat + 0.16 * vitamin_c >= 16, "c5")
    m.addConstr(1.65 * vitamin_d + 2.11 * fat + 0.16 * vitamin_c >= 16, "c6")
    m.addConstr(2 * vitamin_d - 6 * fat >= 0, "c7")
    m.addConstr(5.48 * vitamin_d + 4.28 * fat + 4.11 * vitamin_c <= 101, "c8")
    m.addConstr(1.65 * vitamin_d + 2.11 * fat <= 101, "c9")
    m.addConstr(1.65 * vitamin_d + 2.11 * fat + 0.16 * vitamin_c <= 113, "c10")


    # Resource Constraints (upper bounds)
    m.addConstr(5.48 * vitamin_d <= 165, "r0_vitamin_d")
    m.addConstr(1.65 * vitamin_d <= 128, "r1_vitamin_d")
    m.addConstr(4.28 * fat <= 165, "r0_fat")
    m.addConstr(2.11 * fat <= 128, "r1_fat")
    m.addConstr(4.11 * vitamin_c <= 165, "r0_vitamin_c")
    m.addConstr(0.16 * vitamin_c <= 128, "r1_vitamin_c")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_d:', vitamin_d.x)
        print('fat:', fat.x)
        print('vitamin_c:', vitamin_c.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
