
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_D", lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name="grams_of_fat", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=0)  # No lower bound specified, assuming 0

    # Objective function
    model.setObjective(4 * x0 + 8 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5.48 * x0 <= 165)
    model.addConstr(1.65 * x0 <= 128)
    model.addConstr(4.28 * x1 <= 165)
    model.addConstr(2.11 * x1 <= 128)
    model.addConstr(4.11 * x2 <= 165)
    model.addConstr(0.16 * x2 <= 128)
    model.addConstr(5.48 * x0 + 4.28 * x1 >= 40)
    model.addConstr(5.48 * x0 + 4.11 * x2 >= 19)
    model.addConstr(5.48 * x0 + 4.28 * x1 + 4.11 * x2 >= 19)
    model.addConstr(1.65 * x0 + 2.11 * x1 >= 18)
    model.addConstr(2.11 * x1 + 0.16 * x2 >= 16)
    model.addConstr(1.65 * x0 + 2.11 * x1 + 0.16 * x2 >= 16)
    model.addConstr(2 * x0 - 6 * x1 >= 0)
    model.addConstr(5.48 * x0 + 4.28 * x1 + 4.11 * x2 <= 101)
    model.addConstr(1.65 * x0 + 2.11 * x1 <= 101)
    model.addConstr(1.65 * x0 + 2.11 * x1 + 0.16 * x2 <= 113)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Grams of fat: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
