
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of calcium
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of protein
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B4
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B5


    # Set objective function
    m.setObjective(2.64 * x0 + 7.45 * x1 + 4.13 * x2 + 4.48 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16 * x0 + 23 * x1 + 8 * x2 + 22 * x3 <= 195, "c0")
    m.addConstr(23 * x1 + 22 * x3 >= 34, "c1")
    m.addConstr(16 * x0 + 8 * x2 >= 19, "c2")
    m.addConstr(8 * x2 + 22 * x3 >= 17, "c3")
    m.addConstr(23 * x1 + 8 * x2 + 22 * x3 >= 41, "c4")
    m.addConstr(16 * x0 + 8 * x2 + 22 * x3 >= 41, "c5")
    m.addConstr(6 * x0 - x2 >= 0, "c6")
    m.addConstr(-8 * x2 + 4 * x3 >= 0, "c7")
    m.addConstr(23 * x1 + 22 * x3 <= 91, "c8")
    m.addConstr(16 * x0 + 22 * x3 <= 114, "c9")
    m.addConstr(8 * x2 + 22 * x3 <= 163, "c10")
    m.addConstr(16 * x0 + 23 * x1 <= 161, "c11")
    m.addConstr(23 * x1 + 8 * x2 + 22 * x3 <= 86, "c12")
    m.addConstr(16 * x0 + 23 * x1 + 22 * x3 <= 89, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
