
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_calcium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="grams_of_protein", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="milligrams_of_vitamin_B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x4 = model.addVar(name="milligrams_of_vitamin_B5", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2.64*x1 + 7.45*x2 + 4.13*x3 + 4.48*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 == 16)
    model.addConstr(x2 == 23)
    model.addConstr(x3 == 8)
    model.addConstr(x4 == 22)
    model.addConstr(23*x2 + 22*x4 >= 34)
    model.addConstr(16*x1 + 8*x3 >= 19)
    model.addConstr(8*x3 + 22*x4 >= 17)
    model.addConstr(23*x2 + 8*x3 + 22*x4 >= 41)
    model.addConstr(16*x1 + 8*x3 + 22*x4 >= 41)
    model.addConstr(23*x2 + 8*x3 + 22*x4 >= 41)
    model.addConstr(16*x1 + 23*x2 + 8*x3 + 22*x4 >= 41)
    model.addConstr(6*x1 - x3 >= 0)
    model.addConstr(-8*x3 + 4*x4 >= 0)
    model.addConstr(23*x2 + 22*x4 <= 91)
    model.addConstr(16*x1 + 22*x4 <= 114)
    model.addConstr(8*x3 + 22*x4 <= 163)
    model.addConstr(16*x1 + 23*x2 <= 161)
    model.addConstr(23*x2 + 8*x3 + 22*x4 <= 86)
    model.addConstr(16*x1 + 23*x2 + 22*x4 <= 89)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Grams of protein: {x2.varValue}")
        print(f"Milligrams of vitamin B4: {x3.varValue}")
        print(f"Milligrams of vitamin B5: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
