
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(9.04 * x0 + 6.21 * x1 + 6.36 * x2 + 3.02 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13 * x0 + 10 * x2 >= 15)
    m.addConstr(13 * x0 + 3 * x1 >= 8)
    m.addConstr(13 * x0 + 4 * x3 >= 19)
    m.addConstr(13 * x0 + 3 * x1 + 10 * x2 + 4 * x3 >= 19)
    m.addConstr(12 * x0 + 7 * x1 >= 20)
    m.addConstr(12 * x0 + 12 * x3 >= 15)
    m.addConstr(12 * x0 + 7 * x1 + 11 * x2 + 12 * x3 >= 15)
    m.addConstr(3 * x0 - x2 >= 0)
    m.addConstr(3 * x1 + 10 * x2 <= 53)
    m.addConstr(10 * x2 + 4 * x3 <= 46)
    m.addConstr(3 * x1 + 4 * x3 <= 32)
    m.addConstr(7 * x1 + 12 * x3 <= 69)
    m.addConstr(7 * x1 + 11 * x2 + 12 * x3 <= 66)
    m.addConstr(12 * x0 + 7 * x1 + 12 * x3 <= 35)
    m.addConstr(12 * x0 + 7 * x1 + 11 * x2 <= 46)
    m.addConstr(12 * x0 + 11 * x2 + 12 * x3 <= 48)
    m.addConstr(13 * x0 + 3 * x1 + 10 * x2 + 4 * x3 <= 77)
    m.addConstr(12 * x0 + 7 * x1 + 11 * x2 + 12 * x3 <= 102)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
