
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bowls_of_cereal", lb=0)
    x1 = model.addVar(name="knishes", lb=0)
    x2 = model.addVar(name="peanutbutter_sandwiches", lb=0)
    x3 = model.addVar(name="sashimi", lb=0)

    # Define the objective function
    model.setObjective(9.04 * x0 + 6.21 * x1 + 6.36 * x2 + 3.02 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13 * x0 + 10 * x2 + 4 * x3 >= 15)
    model.addConstr(13 * x0 + 3 * x1 >= 8)
    model.addConstr(13 * x0 + 4 * x3 >= 19)
    model.addConstr(13 * x0 + 3 * x1 + 10 * x2 + 4 * x3 >= 19)
    model.addConstr(12 * x0 + 7 * x1 >= 20)
    model.addConstr(12 * x0 + 12 * x3 >= 15)
    model.addConstr(12 * x0 + 7 * x1 + 11 * x2 + 12 * x3 >= 15)
    model.addConstr(3 * x0 - x2 >= 0)
    model.addConstr(3 * x1 + 10 * x2 <= 53)
    model.addConstr(10 * x2 + 4 * x3 <= 46)
    model.addConstr(3 * x1 + 4 * x3 <= 32)
    model.addConstr(7 * x1 + 12 * x3 <= 69)
    model.addConstr(7 * x1 + 11 * x2 + 12 * x3 <= 66)
    model.addConstr(12 * x0 + 7 * x1 + 12 * x3 <= 35)
    model.addConstr(12 * x0 + 7 * x1 + 11 * x2 <= 46)
    model.addConstr(12 * x0 + 11 * x2 + 12 * x3 <= 48)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls_of_cereal: ", x0.varValue)
        print("knishes: ", x1.varValue)
        print("peanutbutter_sandwiches: ", x2.varValue)
        print("sashimi: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
