
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")


# Set objective function
m.setObjective(8.57 * mary_hours + 3.55 * hank_hours + 6.72 * bill_hours + 7.3 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.43 * hank_hours + 6.07 * bill_hours >= 13)
m.addConstr(11.9 * mary_hours + 3.45 * hank_hours + 2.28 * bill_hours >= 17)
m.addConstr(1.5 * bill_hours + 6.82 * jean_hours >= 10)
m.addConstr(8.64 * hank_hours + 6.82 * jean_hours >= 16)
m.addConstr(8.64 * hank_hours + 1.5 * bill_hours >= 11)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours >= 25)
m.addConstr(8.64 * hank_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 25)
m.addConstr(0.38 * mary_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 25)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 6.82 * jean_hours >= 25)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours >= 19)
m.addConstr(8.64 * hank_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 19)
m.addConstr(0.38 * mary_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 19)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 6.82 * jean_hours >= 19)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours >= 21)
m.addConstr(8.64 * hank_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 21)
m.addConstr(0.38 * mary_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 21)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 6.82 * jean_hours >= 21)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours >= 23)
m.addConstr(8.64 * hank_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 23)
m.addConstr(0.38 * mary_hours + 1.5 * bill_hours + 6.82 * jean_hours >= 23)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 6.82 * jean_hours >= 23)
m.addConstr(11.2 * hank_hours + 1.61 * bill_hours >= 12)
m.addConstr(11.2 * hank_hours + 1.61 * bill_hours + 3.55 * jean_hours >= 22)
m.addConstr(5.99 * mary_hours + 0.43 * hank_hours <= 98)
m.addConstr(0.43 * hank_hours + 11.82 * jean_hours <= 69)
m.addConstr(5.99 * mary_hours + 6.07 * bill_hours <= 86)
m.addConstr(0.43 * hank_hours + 6.07 * bill_hours + 11.82 * jean_hours <= 48)
m.addConstr(5.99 * mary_hours + 6.07 * bill_hours + 11.82 * jean_hours <= 80)
m.addConstr(5.99 * mary_hours + 0.43 * hank_hours + 6.07 * bill_hours + 11.82 * jean_hours <= 80)
m.addConstr(3.45 * hank_hours + 6.68 * jean_hours <= 84)
m.addConstr(11.9 * mary_hours + 3.45 * hank_hours <= 106)
m.addConstr(11.9 * mary_hours + 2.28 * bill_hours <= 74)
m.addConstr(2.28 * bill_hours + 6.68 * jean_hours <= 78)
m.addConstr(11.9 * mary_hours + 6.68 * jean_hours <= 86)
m.addConstr(11.9 * mary_hours + 3.45 * hank_hours + 6.68 * jean_hours <= 56)
m.addConstr(11.9 * mary_hours + 2.28 * bill_hours + 6.68 * jean_hours <= 118)
m.addConstr(11.9 * mary_hours + 3.45 * hank_hours + 2.28 * bill_hours + 6.68 * jean_hours <= 118)
m.addConstr(8.64 * hank_hours + 6.82 * jean_hours <= 50)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours <= 69)
m.addConstr(0.38 * mary_hours + 1.5 * bill_hours + 6.82 * jean_hours <= 35)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours <= 55)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 6.82 * jean_hours <= 44)
m.addConstr(0.38 * mary_hours + 8.64 * hank_hours + 1.5 * bill_hours + 6.82 * jean_hours <= 44)
m.addConstr(11.2 * hank_hours + 1.61 * bill_hours <= 39)
m.addConstr(1.61 * bill_hours + 3.55 * jean_hours <= 74)
m.addConstr(6.39 * mary_hours + 3.55 * jean_hours <= 64)
m.addConstr(6.39 * mary_hours + 11.2 * hank_hours + 1.61 * bill_hours + 3.55 * jean_hours <= 64)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

