
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cornichons = m.addVar(vtype=gp.GRB.INTEGER, name="cornichons")
bananas = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bananas")
ham_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="ham_sandwiches")
kiwis = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")


# Set objective function
m.setObjective(6.27 * cornichons + 1.36 * bananas + 8.12 * ham_sandwiches + 8.7 * kiwis, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * cornichons + 11 * kiwis >= 35)
m.addConstr(5 * cornichons + 5 * ham_sandwiches + 11 * kiwis >= 34)
m.addConstr(1 * cornichons + 4 * bananas + 6 * ham_sandwiches >= 17)
m.addConstr(1 * cornichons + 6 * ham_sandwiches + 4 * kiwis >= 17)
m.addConstr(1 * cornichons + 4 * bananas + 6 * ham_sandwiches >= 33)
m.addConstr(1 * cornichons + 6 * ham_sandwiches + 4 * kiwis >= 33)
m.addConstr(11 * bananas + 9 * kiwis >= 54)
m.addConstr(7 * cornichons + 10 * ham_sandwiches >= 58)
m.addConstr(7 * cornichons + 9 * kiwis >= 42)
m.addConstr(7 * cornichons + 10 * ham_sandwiches + 9 * kiwis >= 57)
m.addConstr(5 * cornichons + 5 * ham_sandwiches <= 95)
m.addConstr(3 * bananas + 5 * ham_sandwiches <= 64)
m.addConstr(5 * cornichons + 3 * bananas <= 165)
m.addConstr(5 * cornichons + 11 * kiwis <= 166)
m.addConstr(5 * ham_sandwiches + 11 * kiwis <= 118)
m.addConstr(5 * cornichons + 5 * ham_sandwiches + 11 * kiwis <= 136)
m.addConstr(5 * cornichons + 3 * bananas + 5 * ham_sandwiches + 11 * kiwis <= 136)
m.addConstr(1 * cornichons + 6 * ham_sandwiches <= 70)
m.addConstr(4 * bananas + 6 * ham_sandwiches <= 56)
m.addConstr(6 * ham_sandwiches + 4 * kiwis <= 95)
m.addConstr(1 * cornichons + 4 * bananas <= 60)
m.addConstr(1 * cornichons + 4 * bananas + 4 * kiwis <= 37)
m.addConstr(1 * cornichons + 6 * ham_sandwiches + 4 * kiwis <= 66)
m.addConstr(4 * bananas + 6 * ham_sandwiches + 4 * kiwis <= 107)
m.addConstr(1 * cornichons + 4 * bananas + 6 * ham_sandwiches <= 85)
m.addConstr(1 * cornichons + 4 * bananas + 6 * ham_sandwiches + 4 * kiwis <= 85)
m.addConstr(7 * cornichons + 9 * kiwis <= 202)
m.addConstr(10 * ham_sandwiches + 9 * kiwis <= 118)
m.addConstr(7 * cornichons + 10 * ham_sandwiches <= 110)
m.addConstr(11 * bananas + 10 * ham_sandwiches <= 69)
m.addConstr(11 * bananas + 10 * ham_sandwiches + 9 * kiwis <= 136)
m.addConstr(7 * cornichons + 11 * bananas + 9 * kiwis <= 196)
m.addConstr(7 * cornichons + 10 * ham_sandwiches + 9 * kiwis <= 221)
m.addConstr(7 * cornichons + 11 * bananas + 10 * ham_sandwiches + 9 * kiwis <= 221)


r0 = 5 * cornichons + 3 * bananas + 5 * ham_sandwiches + 11 * kiwis
r1 = 1 * cornichons + 4 * bananas + 6 * ham_sandwiches + 4 * kiwis
r2 = 7 * cornichons + 11 * bananas + 10 * ham_sandwiches + 9 * kiwis

m.addConstr(r0 <= 194)
m.addConstr(r1 <= 133)
m.addConstr(r2 <= 241)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

