
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name='cornichons', vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name='bananas', vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(name='ham_sandwiches', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='kiwis', vtype=gurobi.GRB.CONTINUOUS)

# Objective function
m.setObjective(6.27*x0 + 1.36*x1 + 8.12*x2 + 8.7*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x0 + 3*x1 + 11*x3 >= 35)
m.addConstr(5*x0 + 5*x2 + 11*x3 >= 34)
m.addConstr(1*x0 + 4*x1 + 6*x2 >= 17)
m.addConstr(1*x0 + 6*x2 + 4*x3 >= 17)
m.addConstr(1*x0 + 4*x1 + 6*x2 >= 33)
m.addConstr(1*x0 + 6*x2 + 4*x3 >= 33)
m.addConstr(11*x1 + 9*x3 >= 54)
m.addConstr(7*x0 + 10*x2 >= 58)
m.addConstr(7*x0 + 9*x3 >= 42)
m.addConstr(7*x0 + 11*x1 + 10*x2 + 9*x3 >= 57)
m.addConstr(5*x0 + 5*x2 <= 95)
m.addConstr(3*x1 + 5*x2 <= 64)
m.addConstr(5*x0 + 3*x1 <= 165)
m.addConstr(5*x0 + 11*x3 <= 166)
m.addConstr(5*x2 + 11*x3 <= 118)
m.addConstr(5*x0 + 5*x2 + 11*x3 <= 136)
m.addConstr(5*x0 + 3*x1 + 5*x2 + 11*x3 <= 136)
m.addConstr(1*x0 + 6*x2 <= 70)
m.addConstr(4*x1 + 6*x2 <= 56)
m.addConstr(6*x2 + 4*x3 <= 95)
m.addConstr(1*x0 + 4*x1 <= 60)
m.addConstr(1*x0 + 4*x1 + 4*x3 <= 37)
m.addConstr(1*x0 + 6*x2 + 4*x3 <= 66)
m.addConstr(4*x1 + 6*x2 + 4*x3 <= 107)
m.addConstr(1*x0 + 4*x1 + 6*x2 <= 85)
m.addConstr(1*x0 + 4*x1 + 6*x2 + 4*x3 <= 85)
m.addConstr(7*x0 + 9*x3 <= 202)
m.addConstr(10*x2 + 9*x3 <= 118)
m.addConstr(7*x0 + 10*x2 <= 110)
m.addConstr(11*x1 + 10*x2 <= 69)
m.addConstr(11*x1 + 10*x2 + 9*x3 <= 136)
m.addConstr(7*x0 + 11*x1 + 9*x3 <= 196)
m.addConstr(7*x0 + 10*x2 + 9*x3 <= 221)
m.addConstr(7*x0 + 11*x1 + 10*x2 + 9*x3 <= 221)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('cornichons: ', x0.varValue)
    print('bananas: ', x1.varValue)
    print('ham_sandwiches: ', x2.varValue)
    print('kiwis: ', x3.varValue)
else:
    print('No solution found')
