
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_John")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Mary")


    # Set objective function
    model.setObjective(9*x0 + 2*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 8*x1 >= 20, "paperwork_competence_min")
    model.addConstr(2*x0 + 8*x1 >= 14, "organization_score_min")
    model.addConstr(5*x0 - 4*x1 >= 0, "john_mary_work_ratio")
    model.addConstr(5*x0 + 8*x1 <= 45, "paperwork_competence_max")
    model.addConstr(2*x0 + 8*x1 <= 45, "organization_score_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by John: {x0.x}")
        print(f"Hours worked by Mary: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
