
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(9*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 8*x2 >= 20, "paperwork_competence_rating")
m.addConstr(2*x1 + 8*x2 >= 14, "organization_score_min")
m.addConstr(5*x1 - 4*x2 >= 0, "mixed_constraint")
m.addConstr(5*x1 + 8*x2 <= 45, "paperwork_competence_rating_max")
m.addConstr(2*x1 + 8*x2 <= 45, "organization_score_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by John: {x1.x}")
    print(f"Hours worked by Mary: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
