
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_John", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Mary", lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(9 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 8 * x2 >= 20, name="paperwork_competence_rating_min")
    model.addConstr(2 * x1 + 8 * x2 >= 14, name="organization_score_min")
    model.addConstr(5 * x1 - 4 * x2 >= 0, name="hourly_constraint")
    model.addConstr(5 * x1 + 8 * x2 <= 45, name="paperwork_competence_rating_max")
    model.addConstr(2 * x1 + 8 * x2 <= 45, name="organization_score_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by John: {x1.varValue}")
        print(f"Hours worked by Mary: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
