
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")


# Set objective
obj = 5*hank**2 + 2*hank*peggy + 9*hank*bill + 8*hank*jean + 3*hank*john + 7*hank*ringo + 6*peggy**2 + 4*peggy*bill + 6*peggy*jean + 4*peggy*john + 9*peggy*ringo + 8*bill**2 + 8*bill*jean + 7*bill*john + 9*bill*ringo + 2*jean**2 + 7*jean*john + 8*jean*ringo + 5*john**2 + 4*john*ringo + 2*ringo**2 + 4*hank + 4*peggy + 6*jean + 1*john + 4*ringo

m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints
org_score = {'hank': 14, 'peggy': 2, 'bill': 9, 'jean': 7, 'john': 4, 'ringo': 1}
paperwork = {'hank': 2, 'peggy': 5, 'bill': 6, 'jean': 9, 'john': 9, 'ringo': 14}
cost = {'hank': 6, 'peggy': 3, 'bill': 14, 'jean': 2, 'john': 14, 'ringo': 14}


m.addConstr(9 * bill + 1 * ringo >= 17)
m.addConstr(9 * bill + 7 * jean >= 40)
m.addConstr(7 * jean**2 + 1 * ringo**2 >= 30)
m.addConstr(7 * jean + 4 * john + 1 * ringo >= 20)
m.addConstr(14 * hank**2 + 2 * peggy**2 + 1 * ringo**2 >= 20)
m.addConstr(7 * jean + 4 * john + 1 * ringo >= 40)
m.addConstr(14 * hank + 2 * peggy + 1 * ringo >= 40)
m.addConstr(14 * hank + 2 * peggy + 9 * bill + 7 * jean + 4 * john + 1 * ringo >= 40)
m.addConstr(9 * jean + 14 * ringo >= 20)
m.addConstr(2 * hank**2 + 6 * bill**2 >= 7)
m.addConstr(9 * jean**2 + 9 * john**2 >= 9)
m.addConstr(6 * bill + 9 * jean >= 13)
m.addConstr(5 * peggy**2 + 14 * ringo**2 >= 17)
m.addConstr(6 * bill**2 + 9 * john**2 >= 20)
m.addConstr(2 * hank + 5 * peggy + 9 * jean >= 23)
m.addConstr(6 * bill**2 + 9 * jean**2 + 9 * john**2 >= 23)
m.addConstr(2 * hank**2 + 5 * peggy**2 + 9 * john**2 >= 23)

# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

