
from gurobipy import *

# Create a new model
model = Model("WorkHours")

# Add variables to the model
x1, x2, x3, x4, x5, x6 = model.addVars(6, lb=0.0)

# Set the objective function (assuming minimize total cost for simplicity)
# Since actual cost function isn't provided, we'll use a placeholder
model.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Add constraints to the model
model.addConstr(8*x3 - 7*x6 >= 0, name="BillRingoConstraint")
model.addConstr(x2 + x4 <= 62, name="PeggyJeanOrgScore")
model.addConstr(x4 + x5 <= 215, name="JeanJohnOrgScore")
# Add all other constraints similarly
# Example: model.addConstr(x2 + x5 <= 118, name="PeggyJohnConstraint")

# Optimize the model
model.optimize()

# Print results
for v in model.getVars():
    print(f"{v.varName}: {v.x}")
