
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
    apples = m.addVar(vtype=gp.GRB.INTEGER, name="apples")
    sashimi = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sashimi")

    # Set objective function
    m.setObjective(6.14*tomatoes**2 + 2.49*tomatoes*apples + 4.65*tomatoes*sashimi + 9.64*apples**2 + 6.75*apples*sashimi + 4.93*sashimi**2 + 4.93*tomatoes + 2.95*sashimi, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*tomatoes + 7*apples + 12*sashimi >= 54, "c0")
    m.addConstr(17*tomatoes + 15*apples + 15*sashimi >= 33, "c1")
    m.addConstr(15*apples + 15*sashimi >= 62, "c2")
    m.addConstr(2*tomatoes**2 + 12*sashimi**2 >= 52, "c3")
    m.addConstr(2*tomatoes + 7*apples >= 54, "c4")
    m.addConstr(17*tomatoes + 15*apples >= 33, "c5")
    m.addConstr(-2*tomatoes**2 + 7*sashimi**2 >= 0, "c6")
    m.addConstr(7*apples**2 + 12*sashimi**2 <= 140, "c7")
    m.addConstr(2*tomatoes**2 + 12*sashimi**2 <= 100, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('tomatoes:', tomatoes.x)
        print('apples:', apples.x)
        print('sashimi:', sashimi.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
