
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="tomatoes", vtype=gurobi.GRB.INTEGER)  # integer
x1 = m.addVar(name="apples", vtype=gurobi.GRB.INTEGER)  # integer
x2 = m.addVar(name="sashimi")  # continuous

# Define the objective function
m.setObjective(6.14*x0**2 + 2.49*x0*x1 + 4.65*x0*x2 + 9.64*x1**2 + 6.75*x1*x2 + 4.93*x2**2 + 4.93*x0 + 2.95*x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(x0**2 + x2**2 >= 52)
m.addConstr(2*x0 + 7*x1 >= 54)
m.addConstr(2*x0 + 7*x1 + 12*x2 >= 54)
m.addConstr(15*x1 + 15*x2 >= 62)
m.addConstr(17*x0 + 15*x1 >= 33)
m.addConstr(17*x0 + 15*x1 + 15*x2 >= 33)
m.addConstr(-2*x0**2 + 7*x2**2 >= 0)
m.addConstr(49*x1**2 + 144*x2**2 <= 140)
m.addConstr(x0**2 + x2**2 <= 100)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Tomatoes: ", x0.varValue)
    print("Apples: ", x1.varValue)
    print("Sashimi: ", x2.varValue)
else:
    print("The model is infeasible")
