
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
oranges = m.addVar(vtype=gp.GRB.INTEGER, name="oranges")

# Set objective function
m.setObjective(1.69 * eggs + 5.7 * oranges, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * eggs + 11 * oranges >= 25, "protein_min")
m.addConstr(14 * eggs + 9 * oranges >= 16, "sourness_min")
m.addConstr(7 * eggs - 1 * oranges >= 0, "eggs_oranges_relation")
m.addConstr(3 * eggs + 11 * oranges <= 55, "protein_max")
m.addConstr(14 * eggs + 9 * oranges <= 68, "sourness_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Eggs: {eggs.x}")
    print(f"  Oranges: {oranges.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

