
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="eggs")
x2 = m.addVar(vtype=GRB.INTEGER, name="oranges")

# Set the objective function
m.setObjective(1.69*x1 + 5.7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 11*x2 >= 25, "Protein_Min")
m.addConstr(14*x1 + 9*x2 >= 16, "Sourness_Min")
m.addConstr(7*x1 - x2 >= 0, "Eggs_Oranges_Balance")
m.addConstr(3*x1 + 11*x2 <= 55, "Protein_Max")
m.addConstr(14*x1 + 9*x2 <= 68, "Sourness_Max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eggs: {x1.x}")
    print(f"Oranges: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
