
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="eggs", vtype=gp.GRB.INTEGER)  # eggs
x2 = m.addVar(name="oranges", vtype=gp.GRB.INTEGER)  # oranges

# Define the objective function
m.setObjective(1.69 * x1 + 5.7 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3 * x1 + 11 * x2 >= 25, name="min_protein")
m.addConstr(14 * x1 + 9 * x2 >= 16, name="min_sourness")
m.addConstr(7 * x1 - x2 >= 0, name="relationship")
m.addConstr(3 * x1 + 11 * x2 <= 55, name="max_protein")
m.addConstr(14 * x1 + 9 * x2 <= 68, name="max_sourness")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Eggs: {x1.varValue}, Oranges: {x2.varValue}")
else:
    print("No optimal solution found.")
