
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
medical_platoons = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")


# Set objective function
m.setObjective(4*pathfinder_teams**2 + 9*medical_platoons**2 + 7*pathfinder_teams + 1*medical_platoons, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*pathfinder_teams + 4*medical_platoons >= 10, "fuel_demand")
m.addConstr(9*pathfinder_teams**2 + 11*medical_platoons**2 >= 17, "offensive_capability")
m.addConstr(7*pathfinder_teams + 5*medical_platoons >= 14, "fun_factor")
m.addConstr(10*pathfinder_teams - 1*medical_platoons >= 0, "teams_platoons_relation")
m.addConstr(7*pathfinder_teams**2 + 4*medical_platoons**2 <= 37, "fuel_demand_squared")
m.addConstr(9*pathfinder_teams + 11*medical_platoons <= 33, "offensive_capability_limit")
m.addConstr(7*pathfinder_teams**2 + 5*medical_platoons**2 <= 38, "fun_factor_squared")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Pathfinder Teams: {pathfinder_teams.x}")
    print(f"  Medical Platoons: {medical_platoons.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

