
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
x1 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Set the objective function
m.setObjective(4*x0**2 + 9*x1**2 + 7*x0 + x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(7*x0 + 4*x1 >= 10, name="total_fuel_demand_min")
m.addConstr(9*x0 + 11*x1 >= 17, name="offensive_capability_min")
m.addConstr(7*x0 + 5*x1 >= 14, name="fun_factor_min")
m.addConstr(10*x0 - x1 >= 0, name="inequality_constraint")
# Corrected fuel demand constraint to linear form
m.addConstr(7*x0 + 4*x1 <= 37, name="total_fuel_demand_max") 
m.addConstr(9*x0 + 11*x1 <= 33, name="offensive_capability_max")
m.addConstr((7*x0)**2 + (5*x1)**2 <= 38**2, name="fun_factor_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x0 = {x0.x}, x1 = {x1.x}")
else:
    print("No optimal solution found")
