
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
    tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sandwiches")
    cereal = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cereal")

    # Set objective function
    m.setObjective(2.44*bacon**2 + 4.98*bacon*tomatoes + 8.8*bacon*sandwiches + 6.8*tomatoes*cereal, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(16*bacon + 8*tomatoes <= 214, "c0")
    m.addConstr(18*bacon + 10*tomatoes + 9*sandwiches + 21*cereal <= 259, "c1")
    m.addConstr(16*bacon + 8*tomatoes >= 17, "c2")
    m.addConstr(8*tomatoes + 14*sandwiches + 10*cereal >= 32, "c3")
    m.addConstr(16*bacon + 8*tomatoes + 10*cereal >= 32, "c4")
    m.addConstr(8*tomatoes**2 + 14*sandwiches**2 + 10*cereal**2 >= 36, "c5")
    m.addConstr(16*bacon + 8*tomatoes + 10*cereal >= 36, "c6")
    m.addConstr(10*tomatoes**2 + 21*cereal**2 >= 49, "c7")
    m.addConstr(10*tomatoes**2 + 9*sandwiches**2 >= 49, "c8")
    m.addConstr(18*bacon + 10*tomatoes >= 34, "c9")
    m.addConstr(18*bacon**2 + 10*tomatoes**2 + 21*cereal**2 >= 40, "c10")
    m.addConstr(10*tomatoes**2 + 9*sandwiches**2 + 21*cereal**2 >= 40, "c11")
    m.addConstr(18*bacon**2 + 9*sandwiches**2 + 21*cereal**2 >= 40, "c12")
    m.addConstr(18*bacon + 10*tomatoes + 21*cereal >= 45, "c13")
    m.addConstr(10*tomatoes**2 + 9*sandwiches**2 + 21*cereal**2 >= 45, "c14")
    m.addConstr(18*bacon + 9*sandwiches + 21*cereal >= 45, "c15")
    m.addConstr(18*bacon + 10*tomatoes + 21*cereal >= 55, "c16")
    m.addConstr(10*tomatoes**2 + 9*sandwiches**2 + 21*cereal**2 >= 55, "c17")
    m.addConstr(18*bacon + 9*sandwiches + 21*cereal >= 55, "c18")
    m.addConstr(14*sandwiches + 10*cereal <= 91, "c19")
    m.addConstr(8*tomatoes + 14*sandwiches <= 68, "c20")
    m.addConstr(16*bacon + 8*tomatoes <= 137, "c21")
    m.addConstr(8*tomatoes + 10*cereal <= 186, "c22")
    m.addConstr(16*bacon + 10*cereal <= 190, "c23")
    m.addConstr(16*bacon + 14*sandwiches + 10*cereal <= 57, "c24")
    m.addConstr(16*bacon + 8*tomatoes + 14*sandwiches + 10*cereal <= 57, "c25")
    m.addConstr(9*sandwiches + 21*cereal <= 228, "c26")
    m.addConstr(18*bacon + 9*sandwiches <= 245, "c27")
    m.addConstr(18*bacon**2 + 10*tomatoes**2 <= 109, "c28")
    m.addConstr(18*bacon + 10*tomatoes + 9*sandwiches <= 147, "c29")
    m.addConstr(10*tomatoes + 9*sandwiches + 21*cereal <= 150, "c30")
    m.addConstr(18*bacon + 10*tomatoes + 9*sandwiches + 21*cereal <= 150, "c31")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
