
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # strips of bacon
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # tomatoes
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # peanutbutter sandwiches
x3 = m.addVar(name="x3", lb=0, type=gurobi.GRB.INTEGER)  # bowls of cereal

# Objective function
m.setObjective(2.44*x0**2 + 4.98*x0*x1 + 8.8*x0*x2 + 6.8*x1*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(16*x0 + 8*x1 + 14*x2 + 10*x3 <= 214)
m.addConstr(18*x0 + 10*x1 + 9*x2 + 21*x3 <= 259)
m.addConstr(16*x0 + 8*x1 >= 17)
m.addConstr(8*x1 + 14*x2 + 10*x3 >= 32)
m.addConstr(16*x0 + 8*x1 + 10*x3 >= 32)
m.addConstr(8*x1**2 + 14*x2**2 + 10*x3**2 >= 36)
m.addConstr(16*x0 + 8*x1 + 10*x3 >= 36)
m.addConstr(10*x1**2 + 21*x3**2 >= 49)
m.addConstr(10*x1**2 + 9*x2**2 >= 49)
m.addConstr(18*x0 + 10*x1 >= 34)
m.addConstr((18*x0)**2 + (10*x1)**2 + (21*x3)**2 >= 40)
m.addConstr(10*x1**2 + 9*x2**2 + 21*x3**2 >= 40)
m.addConstr((18*x0)**2 + (9*x2)**2 + (21*x3)**2 >= 40)
m.addConstr(18*x0 + 10*x1 + 21*x3 >= 45)
m.addConstr(10*x1**2 + 9*x2**2 + 21*x3**2 >= 45)
m.addConstr(18*x0 + 9*x2 + 21*x3 >= 45)
m.addConstr(18*x0 + 10*x1 + 21*x3 >= 55)
m.addConstr(10*x1**2 + 9*x2**2 + 21*x3**2 >= 55)
m.addConstr(18*x0 + 9*x2 + 21*x3 >= 55)
m.addConstr(14*x2 + 10*x3 <= 91)
m.addConstr(8*x1 + 14*x2 <= 68)
m.addConstr(16*x0 + 8*x1 <= 137)
m.addConstr(8*x1 + 10*x3 <= 186)
m.addConstr(16*x0 + 10*x3 <= 190)
m.addConstr(16*x0 + 14*x2 + 10*x3 <= 57)
m.addConstr(16*x0 + 8*x1 + 14*x2 + 10*x3 <= 57)
m.addConstr(9*x2 + 21*x3 <= 228)
m.addConstr(18*x0 + 9*x2 <= 245)
m.addConstr((18*x0)**2 + (10*x1)**2 <= 109)
m.addConstr(18*x0 + 10*x1 + 9*x2 <= 147)
m.addConstr(10*x1 + 9*x2 + 21*x3 <= 150)
m.addConstr(18*x0 + 10*x1 + 9*x2 + 21*x3 <= 150)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
