
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")


# Set objective function
m.setObjective(3 * hank + 3 * peggy + 1 * laura + 8 * bill + 7 * bobby, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * laura + 5 * bobby >= 59)
m.addConstr(12 * laura + 17 * bill >= 53)
m.addConstr(15 * peggy + 17 * bill >= 133)
m.addConstr(17 * bill + 5 * bobby >= 54)
m.addConstr(4 * hank + 5 * bobby >= 74)
# ... (add all other constraints similarly)


# Resource constraints (upper bounds) - these were not explicitly stated in the problem but are provided in the context
m.addConstr(4 * hank + 15 * peggy + 12 * laura + 17 * bill + 5 * bobby <= 748, "r0_upper_bound")
m.addConstr(23 * hank + 21 * peggy + 1 * laura + 9 * bill + 16 * bobby <= 415, "r1_upper_bound")
m.addConstr(15 * hank + 19 * peggy + 18 * laura + 22 * bill + 19 * bobby <= 639, "r2_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

