
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="x0")  # hours worked by Hank
    x1 = model.addVar(lb=0, name="x1")  # hours worked by Peggy
    x2 = model.addVar(lb=0, name="x2")  # hours worked by Laura
    x3 = model.addVar(lb=0, name="x3")  # hours worked by Bill
    x4 = model.addVar(lb=0, name="x4")  # hours worked by Bobby

    # Objective function
    model.setObjective(3*x0 + 3*x1 + x2 + 8*x3 + 7*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x0 + 15*x1 + 12*x2 >= 113)
    model.addConstr(4*x0 + 12*x2 + 17*x3 >= 113)
    model.addConstr(4*x0 + 15*x1 + 17*x3 >= 113)
    model.addConstr(12*x2 + 17*x3 + 5*x4 >= 113)
    model.addConstr(15*x1 + 12*x2 + 17*x3 >= 113)
    model.addConstr(4*x0 + 15*x1 + 12*x2 >= 98)
    model.addConstr(4*x0 + 12*x2 + 17*x3 >= 98)
    model.addConstr(4*x0 + 15*x1 + 17*x3 >= 98)
    model.addConstr(12*x2 + 17*x3 + 5*x4 >= 98)
    model.addConstr(15*x1 + 12*x2 + 17*x3 >= 98)
    model.addConstr(4*x0 + 15*x1 + 12*x2 >= 124)
    model.addConstr(4*x0 + 12*x2 + 17*x3 >= 124)
    model.addConstr(4*x0 + 15*x1 + 17*x3 >= 124)
    model.addConstr(12*x2 + 17*x3 + 5*x4 >= 124)
    model.addConstr(15*x1 + 12*x2 + 17*x3 >= 124)
    model.addConstr(4*x0 + 15*x1 + 12*x2 >= 149)
    model.addConstr(4*x0 + 12*x2 + 17*x3 >= 149)
    model.addConstr(4*x0 + 15*x1 + 17*x3 >= 149)
    model.addConstr(12*x2 + 17*x3 + 5*x4 >= 149)
    model.addConstr(15*x1 + 12*x2 + 17*x3 >= 149)
    model.addConstr(23*x0 + 21*x1 + x2 + 9*x3 + 16*x4 >= 54)
    model.addConstr(19*x1 + 22*x3 >= 69)
    model.addConstr(22*x3 + 19*x4 >= 122)
    model.addConstr(15*x0 <= 748)
    model.addConstr(19*x1 <= 415)
    model.addConstr(18*x2 <= 639)
    model.addConstr(22*x3 <= 639)
    model.addConstr(19*x4 <= 639)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Hank: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
        print("Hours worked by Bill: ", x3.varValue)
        print("Hours worked by Bobby: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
